package cn.com.duiba.kjy.api.params;

import lombok.Data;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * Created by zhangshun on 2019/2/21.
 */
@Data
@ToString
public class UserVisitParam extends PageQuery {

    private Long sellerId;
    private Date beginDate;
    private Date endDate;
    private Integer readMark;
    private Long scId;
    private Long visitId;
    private Long contentId;
    /**
     * 记录类型：article =文章、seller =名片 activity =活动 daily=日报
     */
    private String contentType;
    /**
     * 代理人内容列表
     */
    private List<Long> scIds;

    /**
     * 访客Id列表
     */
    private List<Long> visitIds;

    /**
     * 排序是否通过is_expose和gmt_create排序
     */
    private Boolean needOrderByIsExposed = Boolean.FALSE;

    /**
     * 是否需要排序
     */
    private Boolean isNeedOrder = Boolean.TRUE;

    /**
     * 推送类型
     */
    private List<Integer> pushTypes;
}
