package cn.com.duiba.kjy.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ContentDto;
import cn.com.duiba.kjy.api.dto.SellerImportTaskDto;
import cn.com.duiba.kjy.api.dto.content.ContentPlusDto;
import cn.com.duiba.kjy.api.enums.seller.SellerImportTaskStatusEnum;
import cn.com.duiba.kjy.api.params.ContentSellerRelationParam;

import java.util.List;

/**
 * 销售员导入服务类
 * @author lizhi
 * @date 2019-06-04
 */
@AdvancedFeignClient
public interface RemoteSellerImportService {

    /**
     * 获取销售员最近上传次数
     * @param sellerId 销售员ID
     * @param minute 最近几分钟
     * @return 上传次数
     */
    Integer getSellerImportCount(Long sellerId, Integer minute);

    /**
     * 获取销售员总上传次数
     * @param sellerId 销售员ID
     * @return 总上传次数
     */
    Long getSellerImportTotalCount(Long sellerId);

    /**
     * 根据销售员和链接查询任务，若不存在，则新插入一条任务并返回
     * @param sellerId 销售员ID
     * @param url 链接
     * @return 任务
     */
    SellerImportTaskDto getOrAddSellerImportTask(Long sellerId, String url);

    /**
     * 根据销售员和链接查询任务，若不存在，则新插入一条任务并返回(增加导入来源和导入类型)
     * @param sellerId 销售员ID
     * @param url 链接
     * @param importSource 导入来源 @see ImportEnum
     * @param importType 导入类型 @see SellerImportTypeEnum
     * @return 任务
     */
    SellerImportTaskDto getOrAddSellerImportTaskV3(Long sellerId, String url,Integer importSource, Integer importType);

    /**
     * 异步解析销售员导入文章
     * @param taskId 任务ID
     * @return true-发送消息成功，false-发送消息失败
     */
    Boolean asyncAnalyzeSellerImportNew(Long taskId);

    /**
     * 异步解析销售员导入文章
     * @param taskId 任务id
     * @param type 类型 @see SellerImportTypeEnum
     * @return
     */
    Boolean asyncAnalyzeSellerImportNewV2(Long taskId, Integer type);

    /**
     * 根据ID查询任务
     * @param id 任务ID
     * @return 任务
     */
    SellerImportTaskDto getTaskById(Long id);


    /**
     * 根据ID查询任务
     * @param cid 内容ID
     * @return 任务
     */
    SellerImportTaskDto getTaskByContentId(Long cid ,Long sid);

    /**
     * 任务完成，绑定文章和销售员关系，更改任务状态
     * @param taskId 任务ID
     * @param sellerId 销售员ID
     * @return true-成功，false-失败
     */
    Boolean completeTask(Long taskId, Long sellerId);

    /**
     * 根据URL获取内容ID-废弃
     * @deprecated 请使用 getContentIdByUrlCode 接口
     * @param url URL链接
     * @return 内容ID
     */
    @Deprecated
    Long getContentIdByUrl(String url);

    /**
     * 根据URL的Md5值获取内容ID
     * @param urlCode URL链接Md5值
     * @return 内容ID
     */
    Long getContentIdByUrlCode(String urlCode);

    /**
     * 更新任务解析结果
     * @param taskId 任务ID
     * @param state 任务状态
     * @see SellerImportTaskStatusEnum
     * @param contentId 内容ID
     * @param message 错误信息
     * @return 0-失败
     */
    int updateTaskAnalyzeResult(Long taskId, Integer state, Long contentId, String message);

    /**
     * 获取最热门的销售员上传文章
     * @return 热门文章
     */
    List<ContentPlusDto> getHotPlusList();

    /**
     * 根据绑定关系，查询内容
     * @param param 参数
     * @return 热门文章
     */
    List<ContentPlusDto> getContentsPlus(ContentSellerRelationParam param);

    /**
     * 根据绑定关系，类型查询内容
     * @param type 内容类型
     * @return 热门文章
     */
    List<ContentPlusDto> getVideoHotList(String type);
    /**
     * 根据绑定关系，查询内容
     * @param param 参数
     * @return 热门文章
     */
    List<ContentDto> getContents(ContentSellerRelationParam param);

    /**
     * 解绑销售员和内容
     * @param sellerId 销售员ID
     * @param contentId 内容ID
     * @return true-成功，false-失败
     */
   Boolean unbind(Long sellerId, Long contentId);

    /**
     * 删除销售员上传任务
     * @param sellerId 销售员ID
     * @param taskId 任务ID
     * @return true-成功，false-失败
     */
    Boolean taskDelete(Long sellerId, Long taskId);

    /**
     * 查询销售员未完成的上传任务
     * @param sellerId 销售员ID
     * @param type 上传任务类型
     * @return
     */
   List<SellerImportTaskDto> getInProgressTask(Long sellerId, Integer type);


    /**
     * 更新任务解析结果
     * @param taskId 任务ID
     * @param state 任务状态
     * @see SellerImportTaskStatusEnum
     * @param contentId 内容ID
     * @param message 错误信息
     * @param urlCode urlMd5值
     * @return 0-失败
     */
    int updateTaskAnalyzeResultV2(Long taskId, Integer state, Long contentId, String message,String urlCode);

    /**
     * 获取代理人导入的文章id列表
     * @param sellerId
     * @return
     */
    List<Long> getSellerImportContentIds(Long sellerId);

}
