package cn.com.duiba.kjy.api.remoteservice.process;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.preInstall.PreInstallBatchDto;
import cn.com.duiba.kjy.api.dto.preInstall.PreInstallSellerDto;
import cn.com.duiba.kjy.api.dto.process.ProcessFlowDto;
import cn.com.duiba.kjy.api.dto.process.ProcessRoleDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.preInstall.ActivateParam;
import cn.com.duiba.kjy.api.params.preInstall.AddBatchParam;
import cn.com.duiba.kjy.api.params.preInstall.LivePageQuery;
import cn.com.duiba.kjy.api.params.preInstall.PreInstallPageQuery;
import cn.com.duiba.kjy.api.params.process.FlowPageQuery;
import com.hazelcast.client.impl.protocol.codec.ListIsEmptyCodec;

import java.util.List;
import java.util.Map;

/**
 * @auther: xiaotian
 * @date: 2020-05-04 14:17
 * @description: 流程remote接口
 */
@AdvancedFeignClient
public interface RemoteProcessService {

    /**
     * 根据外健ID获取当前流程所在角色
     * @param outIds
     * @return
     */
    Map<Long, List<ProcessRoleDto>> getPresentProcess(List<Long> outIds);


    /**remoteSerialPayService
     * 根据外键ID获取
     * @param outId
     * @return
     */
    List<ProcessFlowDto>  getByOutId(Long outId);


    /**
     * 根据角色类型列表，返回对应的map
     * @param typeList
     * @return
     */
    Map<Long,List<ProcessRoleDto>>  getListMapByTypeIds(List<Integer> typeList);


    /**
     * 通过用户的bizId获取角色列表
     * @param bizId
     * @return
     */
    List<Integer>  getRoleTypesByBizId(String bizId);


    /**
     * 分页获取
     * @param pageQuery
     * @return
     */
    Page<ProcessFlowDto>  queryProcessPage(FlowPageQuery pageQuery);


}
