package cn.com.duiba.kjy.api.enums.seller;

/**
 * 代理人动态业务类型枚举
 * @author zhanghuifeng
 * date 2020/3/21-2:18 下午
 */
public enum SellerDynamicBizTypeEnum {

    USER_FORWARD(1, "转发记录"),
    USER_VISIT(2, "访问记录"),
    SELLER_CLUE(3, "销售线索"),
    ;
    private Integer code;

    private String desc;

    SellerDynamicBizTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerDynamicBizTypeEnum getByCode(Integer code) {
        for (SellerDynamicBizTypeEnum enumVal : SellerDynamicBizTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerDynamicBizTypeEnum enumVal : SellerDynamicBizTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
