package cn.com.duiba.kjy.api.dto.companyTradeCaseTemplate;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 公司行业案例模板
 * @author kjj mybatis generator 
 * 2020-05-07
 */
@Data
public class CompanyTradeCaseTemplateDto implements Serializable {
    private static final long serialVersionUID = 15888628518412801L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *行业id，对应tb_company_trade.id
     */
    private Long tradeId;

    /**
     *
     *总公司ID，对应tb_company.id
     */
    private Long companyId;

    /**
     *
     *保险案例类型
     */
    private Integer insuranceType;

    /**
     *
     *理赔原因
     * max length = 255
     */
    private String claimReason;

    /**
     *
     *理赔金额
     * max length = 255
     */
    private String claimAmount;

    /**
     *
     *关联内容id，tb_content.id
     * not null default = null
     */
    private Long contentId;

    /**
     *
     *用户姓名
     * max length = 20
     */
    private String userName;

    /**
     *
     *用户年龄
     */
    private Integer userAge;

    /**
     *
     *案例首图
     * max length = 255
     */
    private String mainImg;

    /**
     *
     *案例描述
     * max length = 255
     */
    private String caseDesc;

    /**
     *
     *案例标题
     * max length = 255
     */
    private String caseTitle;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}