package cn.com.duiba.kjy.api.dto.sellercard;

import cn.com.duiba.kjy.api.util.NumberUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by dugq on 2019-07-29.
 * 客户用例 仅用于接收参数
 */
@Data
public class CaseDto implements Serializable {
    private static final long serialVersionUID = 3750043947685268067L;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * HBase key
     */
    private String id;

    /**
     * 客户姓名
     */
    private String name;

    /**
     * "0:男 1:女",
     */
    @Deprecated
    private Integer sex;

    /**
     * 客户年龄
     */
    private Integer age;

    /**
     * 客户年收入
     */
    @Deprecated
    private String yearIncome;

    /**
     * 案例类型(投保险种)
     */
    @Deprecated
    private String caseType;

    /**
     * 保费
     */
    @Deprecated
    private String premium;

    /**
     * 权益
     */
    @Deprecated
    private String assets;

    /**
     * 案例描述
     */
    private String caseIntro;

    /**
     * 案例图片
     */
    private String casePics;

    /**
     * 购买产品
     */
    private String product;

    /**
     * 职业
     */
    private String job;

    /**
     * 用户版本
     *
     * @see cn.com.duiba.kjy.api.enums.version.UserVersionEnum
     */
    private Integer userVersion;

    /**
     * 必填项是否完善
     */
    private boolean complete;

    /**
     * 理赔原因
     */
    private String claimReason;

    /**
     * 案例首图
     */
    private String mainImg;
    /**
     * 案例标题
     */
    private String caseTitle;

    /**
     * 保险案例类型
     */
    private Integer insuranceType;

    /**
     * 理赔金额
     */
    private String claimAmount;

    /**
     * 是否展示，默认展示
     */
    private Boolean isShow = true;

    /**
     * 创建时间，需要根据该时间排序
     */
    private Date gmtCreate;

    /**
     * 是否完善了客户案例
     *
     * @return
     */
    public boolean isComplete() {
        //拥有版本信息  就表示为新版本
        if(NumberUtil.isNotNullOrLteZero(userVersion)){
            return complete;
        }
        //保险版 数据是否完善判断
        if (StringUtils.isBlank(this.name)) {
            return false;
        }
        if (StringUtils.isBlank(this.caseType)) {
            return false;
        }
        if (StringUtils.isBlank(this.premium)) {
            return false;
        }
        if (StringUtils.isBlank(this.assets)) {
            return false;
        }
        if (StringUtils.isBlank(this.caseIntro)) {
            return false;
        }

        return true;
    }

}
