package cn.com.duiba.kjy.api.enums.invitationLetter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/3/17 9:13 PM
 */
public enum InvitationConfStateEnum {

    PREVIEW(0, "预览"),
    PRODUCE(1, "正式"),
    ;

    private Integer type;

    private String desc;

    InvitationConfStateEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, InvitationConfStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InvitationConfStateEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static InvitationConfStateEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
