package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerDynamicPageDto;
import cn.com.duiba.kjy.api.params.seller.SellerDynamicSearchParams;


/**
 * 代理人动态信息remote
 * @author zhanghuifeng
 * date 2020/3/21-2:10 下午
 */
@AdvancedFeignClient
public interface RemoteSellerDynamicService {

    /**
     * 瀑布流分页查询
     * @param sellerId 代理人ID
     * @param dynamicType 动态类型 {@link cn.com.duiba.kjy.api.enums.seller.SellerDynamicTypeEnum}
     * @param lastMinId 上一页最小主键ID
     * @param pageSize 每页条数
     * @return 集合
     */
    @Deprecated
    SellerDynamicPageDto pageList(Long sellerId, Integer dynamicType, Long lastMinId, Integer pageSize);

    /**
     * 查询代理人动态信息
     * 瀑布流分页
     * @param params
     * @return
     */
    SellerDynamicPageDto selectList(SellerDynamicSearchParams params);
}
