package cn.com.duiba.kjy.api.dto.seller;

import cn.com.duiba.kjy.api.enums.seller.DistributionTypeEnum;

import java.io.Serializable;

/**
* 邀请返现规则
*/
public class DistributionAwardRuleDto implements Serializable {

    private static final long serialVersionUID = 4796286341589003596L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 一阶奖励（分）
    */
    private Integer firstOrderAward;

    /**
    * 二阶奖励（分）
    */
    private Integer secondOrderAward;

    /**
    * 额外奖励（分）
    */
    private Integer extraAward;

    /**
    * 规则描述
    */
    private String description;

    /**
    * 规则类型，1:普通邀请；2:会销邀请
     * @see DistributionTypeEnum
    */
    private Integer ruleType;

    /**
    * 规则图片
    */
    private DistributionAwardRuleImagsDto images;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setFirstOrderAward(Integer firstOrderAward) {
        this.firstOrderAward = firstOrderAward;
    }

    public Integer getFirstOrderAward() {
        return firstOrderAward;
    }

    public void setSecondOrderAward(Integer secondOrderAward) {
        this.secondOrderAward = secondOrderAward;
    }

    public Integer getSecondOrderAward() {
        return secondOrderAward;
    }

    public void setExtraAward(Integer extraAward) {
        this.extraAward = extraAward;
    }

    public Integer getExtraAward() {
        return extraAward;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public DistributionAwardRuleImagsDto getImages() {
        return images;
    }

    public void setImages(DistributionAwardRuleImagsDto images) {
        this.images = images;
    }
}

