package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SiteSaleQrCodeInfoDto;
import cn.com.duiba.kjy.api.dto.seller.SellerIdAndSellerNameAndQrCodeIdDto;

import java.util.List;

/**
 * 会销码相关信息
 * @author zhanghuifeng
 * date 2019/11/26-1:47 下午
 */
@AdvancedFeignClient
public interface RemoteSiteSaleQrCodeInfoService {

    /**
     * 保存
     * @param dto
     * @return
     */
    Long save(SiteSaleQrCodeInfoDto dto);

    /**
     * 更新二维码url
     * @param id
     * @param qrCodeUrl
     * @return
     */
    Boolean updateQrCodeUrl(Long id, String qrCodeUrl);

    /**
     * 通过id批量查询
     * @param ids
     * @return
     */
    List<SiteSaleQrCodeInfoDto> findByIds(List<Long> ids);

    /**
     * 通过特权销售id和代理id或名称查询qrCodeId
     * @param sellerId
     * @param agentSellerId
     * @param agentName
     * @return
     */
    List<Long> selectIdsBySellerAndAgentSellerOrName(Long sellerId,Long agentSellerId,String agentName);

    /**
     * 根据qrCodeId查询对应的代理销售名称
     * @param qrCodeIds
     * @return
     */
    List<SellerIdAndSellerNameAndQrCodeIdDto> selectSellerIdAndNameByQrCodeId(List<Long> qrCodeIds);
}
