package cn.com.duiba.kjy.api.enums.resourceLocator;

import com.google.common.collect.Lists;

import java.util.List;
import java.util.Objects;

/**
 * 资源类型
 *
 * @author 吴文哲
 * @date 2020-04-24 11:40
 **/
public enum ResourceLocatorTypeEnum {
    //icon 区域
    MATERIAL_CONTENT(ResourceLocatorTabEnums.INDEX_ICON,101, "发圈素材"),
    GRASS_MATERIAL(ResourceLocatorTabEnums.INDEX_ICON,102, "种草素材"),
    TEST_GAME(ResourceLocatorTabEnums.INDEX_ICON,103, "趣味测试"),
    COMPANY_AREA(ResourceLocatorTabEnums.INDEX_ICON,104, "公司专区"),
    GREETING_CARD(ResourceLocatorTabEnums.INDEX_ICON,105, "心意贺卡"),
    INVITATION_LETTER(ResourceLocatorTabEnums.INDEX_ICON,106, "邀请函"),
    GAME_LOTTERY(ResourceLocatorTabEnums.INDEX_ICON,107, "抽奖游戏"),
    UPLOAD_LINK(ResourceLocatorTabEnums.INDEX_ICON,108, "上传链接"),
    ELECTRONIC_ALBUM(ResourceLocatorTabEnums.INDEX_ICON,109, "电子相册"),
    INVITE_CASH_BACK(ResourceLocatorTabEnums.INDEX_ICON,110, "邀请返现"),

    //首页信息流区域
    MATERIAL_CONTENT_FLOAT(ResourceLocatorTabEnums.INDEX_MESSAGE_FLOAT,201, "发圈素材"),
    GRASS_MATERIAL_FLOAT(ResourceLocatorTabEnums.INDEX_ICON,202, "种草素材"),
    COMPANY_AREA_FLOAT(ResourceLocatorTabEnums.INDEX_MESSAGE_FLOAT,203, "公司专区"),
    CUSTOMER_CASES_FLOAT(ResourceLocatorTabEnums.INDEX_MESSAGE_FLOAT,204, "客户案例"),

    ;
    /**
     * icon区 资源类型
     */
    public static List<ResourceLocatorTypeEnum> ICON_RESOURCE_TYPE = Lists.newArrayList();

    /**
     * 信息流资源类型
     */
    public static List<ResourceLocatorTypeEnum> FLOAT_RESOURCE_TYPE = Lists.newArrayList();

    static {
        for (ResourceLocatorTypeEnum enums : values()) {
            if (Objects.equals(enums.getTabType(),ResourceLocatorTabEnums.INDEX_ICON)) {
                ICON_RESOURCE_TYPE.add(enums);
            } else if (Objects.equals(enums.getTabType(),ResourceLocatorTabEnums.INDEX_MESSAGE_FLOAT)) {
                FLOAT_RESOURCE_TYPE.add(enums);
            }
        }
    }

    /**
     * tab类型
     */
    private ResourceLocatorTabEnums tabType;

    /**
     * 类型
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ResourceLocatorTypeEnum(ResourceLocatorTabEnums tabType,Integer code, String desc) {
        this.code = code;
        this.desc = desc;
        this.tabType = tabType;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public ResourceLocatorTabEnums getTabType() {
        return tabType;
    }
}
