package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.constant.KjyRuntimeException;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * @author 吴文哲
 * @date 2019-08-14 21:41
 **/
public class ScIdConverter {

    /**
     * 序列化销售ID  得到 memberId 会员ID
     * @param scId
     * @return
     */
    public static Long encode(Long scId){
        if(Objects.isNull(scId)){
            throw new KjyRuntimeException("销售ID为空,无法获取会员ID");
        }
        //scId大于999999
        if(scId > 999999999L){
            throw new KjyRuntimeException("销售ID最大支持999999999");
        }
        String scIdStr = String.valueOf(scId);
        //第一位是长度
        int length = scIdStr.length();
        //需要补位的长度
        int replaceLength = 9-length;
        //补位数值
        String replaceStr =  SellerIdConverter.getReplaceStr(replaceLength,scIdStr);

        return Long.valueOf(length + replaceStr + scIdStr);

    }



    /**
     * 获取个位数
     * @param num
     * @return
     */
    private static int getUnits(int num) {
        return num>9?num%10:num;
    }


    /**
     * 反序列化会员ID 校验失败会返回-1
     * @param sourceMemberId
     * @return
     */
    public static Long decode(Long sourceMemberId){
        return validate(sourceMemberId)?innerDecode(sourceMemberId+""):-1L;
    }

    /**
     * 内部转换  用会员ID的第一位去截取指定长度的 sellId
     * @param memberId
     * @return
     */
    private static Long innerDecode(String memberId){
        int length = Integer.valueOf(memberId.substring(0,1));
        int replaceLength = 10-length;
        return Long.valueOf(memberId.substring(replaceLength,10));
    }

    /**
     * 根据会员ID 校验会员ID是否正确
     *
     * @param sourceMemberId 原会员ID
     * @return 返回校验结果
     */
    public static boolean validate(Long sourceMemberId){
        String memberId = sourceMemberId+"";
        if(StringUtils.isEmpty(memberId) || memberId.length()!=10){
            return false;
        }
        Long realscId = innerDecode(memberId);
        return sourceMemberId.equals(encode(realscId));

    }

    /**
     * 反序列化scId，校验失败会返回sourceMemberId
     * @param sourceMemberId 加密后的scId
     * @return 反序列化后的scId
     */
    public static Long decodeOrGetSelf(Long sourceMemberId){
        if (sourceMemberId == null) {
            return null;
        }
        Long decode = decode(sourceMemberId);
        if (NumberUtil.isNullOrLteZero(decode)) {
            return sourceMemberId;
        }
        return decode;
    }

    public static void main(String[] args) {
        for(long l=0;l<184;l++){
            long encode = encode(l);
            System.out.println(encode);
            long decode = decode(encode);
            if(l!=decode){
                System.out.println("encode:"+encode+" decode:"+decode);
            }

        }
    }

}
