package cn.com.duiba.kjy.api.params.pay;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 兑吧微信支付记录查询参数
 * @author lizhi
 * @date 2020/1/6 12:03 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WxDuiBaPayRecordParam extends PageQuery {

    private static final long serialVersionUID = -3016917818691500195L;

    /**
     * 客集集退款单号
     */
    private String bizRefundNo;

    /**
     * 客集集订单号
     */
    private String bizOrderNo;

    /**
     * 兑吧分配给业务方的类型和bizOrderNo配合使用
     */
    private Integer bizType;

    /**
     * 支付流水号，兑吧订单号，商户订单号
     */
    private String orderNo;

    /**
     * 支付状态，兑吧返回
     */
    private Integer chargeStatus;

    /**
     * 第三方支付支付流水号,微信支付订单号
     */
    private String transactionNo;

    /**
     * 客集集业务类型
     */
    private Integer kjjBizType;

    /**
     * 客集集业务对应表的主键
     */
    private Long kjjBizId;
}
