package cn.com.duiba.kjy.api.remoteservice.serialPay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.orderRefund.OrderRefundDto;
import cn.com.duiba.kjy.api.dto.serialPayRecord.SerialPayRecordDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.PageQuery;
import cn.com.duiba.kjy.api.params.orderRefund.CheckParam;
import cn.com.duiba.kjy.api.params.orderRefund.OrderPageQuery;
import cn.com.duiba.kjy.api.params.preInstall.SerialPayPageQuery;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayRefundNotifyResponse;

import java.util.List;

/**
 * 功能描述：销售申请退款接口
 *
 * @Auther: xiaotian
 * @Date: 2020/1/3 13:50
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteOrderRefundService {

    /**
     * 插入退款记录
     * @param orderRefundDto
     * @return
     */
    boolean insert(OrderRefundDto orderRefundDto) throws KjyCenterException;

    /**
     * 更新
     * @param orderRefundDto
     * @return
     */
    boolean update(OrderRefundDto orderRefundDto);


    /**
     * 取消退款
     * @param orderRefundDto
     * @return
     */
    boolean cancel(OrderRefundDto orderRefundDto);


    /**
     * 该付款订单可退的最大金额
     * @param orderId
     * @return
     */
    Long canRefundAmount(Long orderId);

    /**
     * 财务审核
     * @param checkParam
     * @return
     */
    boolean check(CheckParam checkParam) throws KjyCenterException;

    /**
     * 筛选列表
     * @param pageQuery
     * @return
     */
    Page<OrderRefundDto> qureyList(OrderPageQuery pageQuery);

    /**
     * 根据付款订单id获取退款记录
     * @param orderId
     * @return
     */
    List<OrderRefundDto>  queryByPayOrderId(Long orderId);


    /**
     * 根据主键ID的list获取退款记录
     * @param ids
     * @return
     */
    List<OrderRefundDto>  queryByIds(List<Long> ids);


    /**
     * 通过ID获取详情
     */
    OrderRefundDto  queryById(Long id);


    /**
     * 退款结果回调
     * @param notifyResponse 退款结果，客集集支付系统回调信息
     */
    void wxPayKjyRefundNotify(WxPayRefundNotifyResponse notifyResponse);

}
