package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by xiaotian on 2020/4/8.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerDistributeSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -2983371748132642436L;

    /**
     * 付费时间(查询开始时间)
     */
    private Date vipTimeStart;

    /**
     * 付费时间（查询结束时间）
     */
    private Date vipTimeEnd;

    /**
     * 分配时间（查询开始时间）
     */
    private Date distributeTimeStart;

    /**
     * 分配时间（查询结束时间）
     */
    private Date distributeTimeEnd;

    /**
     * 被分配的内部销售ID
     */
    private Long sellerId;


}
