package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerStatisticsDto;

/**
 * 销售员统计服务
 * @author zhanghuifeng
 * date 2019-07-23-16:25
 */
@AdvancedFeignClient
public interface RemoteSellerStatisticsService {

    /**
     * 根据销售ID更新统计数据
     * @param dto
     * @return
     */
    Boolean updateBySellerId(SellerStatisticsDto dto);

    /**
     * 根据销售ID查询统计数据
     * @param sellerId
     * @return
     */
    SellerStatisticsDto getBySellerId(Long sellerId);
}
