package cn.com.duiba.kjy.api.dto.home;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangbinbin
 * @create 2020-03-20 11:59
 * @descript 首页获客爆文dto
 */
@Data
public class GuestContentDto implements Serializable {

    private static final long serialVersionUID = -646280377860707234L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 内容id，对应tb_content主键id
     */
    private Long contentId;

    /**
     * 内容类型
     */
    private String contentType;

    /**
     * 内容版本类型
     * @see cn.com.duiba.kjy.api.enums.version.ContentVersionEnum
     */
    private Integer contentVersion;

    /**
     * 内容标题
     */
    private String contentTitle;

    /**
     * 内容封面图
     */
    private String mainImgUrl;

    /**
     * 文章多图
     */
    private String homeImgUrl;

    /**
     * 是否共有
     */
    private Integer publicly;

    /**
     * 标签数据
     */
    private String dataTag;

    /**
     * 三级标签
     */
    private String thirdTag;

}
