package cn.com.duiba.kjy.api.enums.process;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 审批流程角色类型枚举
 * @author xiaotian
 * @date 2020/1/7 3:43 PM
 */
public enum ProcessRoleTypeEnum {

    /**
     * 销售主管
     */
    SALES_MANAGER(1, "销售主管"),
    /**
     * 财务
     */
    FINANCE(2,"财务"),
    ;

    private Integer code;
    private String desc;

    ProcessRoleTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, ProcessRoleTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ProcessRoleTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static ProcessRoleTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }


    private static final List<ProcessRoleTypeEnum> SERIAL_CHECK_PROCESS = Arrays.asList(SALES_MANAGER,FINANCE);


    /**
     * 获取下一个节点
     * @param processRoleTypeEnum
     * @return
     */
    public static ProcessRoleTypeEnum nextRoleType(ProcessRoleTypeEnum processRoleTypeEnum) {
        int index = SERIAL_CHECK_PROCESS.indexOf(processRoleTypeEnum);
        if(index+1>=SERIAL_CHECK_PROCESS.size()){
            return null;
        }
        return SERIAL_CHECK_PROCESS.get(index+1);
    }

}
