package cn.com.duiba.kjy.api.remoteservice.grabmaterial;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.materialContent.MaterialContentPushDto;
import cn.com.duiba.kjy.api.dto.materialContent.MaterialContentPushExtDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.grabmaterial.MaterialPushSearchParam;

import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2020-05-29 15:29
 * @description: 发圈素材推送
 */
@AdvancedFeignClient
public interface RemoteMaterialContentPushService {

    /**
     * 判断是否超限，每天最多创建3条
     * @param releaseTime
     * @return
     */
    boolean checkCount(Date releaseTime);

    /**
     * 新增/编辑 发圈素材推送内容
     * @param dto
     * @return
     */
    Long saveOrUpdate(MaterialContentPushDto dto);


    /**
     * 通过id删除
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    MaterialContentPushDto findById(Long id);

    /**
     * 查询发圈素材推送列表
     * @param params
     * @return
     */
    Page<MaterialContentPushExtDto> selectList(MaterialPushSearchParam params);

}
