package cn.com.duiba.kjy.api.dto.explosionContent;

import lombok.Data;
import lombok.ToString;

import java.util.List;

/**
 * @Author chentiecheng
 * @Date 2020/1/9 9:03 下午
 */
@Data
@ToString(callSuper = true)
public class ExplosionContentExtDto extends ExplosionContentDto {
    private static final long serialVersionUID = -8881075531895659842L;
    /**
     * 爆款素材默认转发量  10万
     */
    public static final Integer DEFAULT_SHARE_NUM = 10;
    /**
     * 爆款素材默认转发量  10万 字符串常量
     */
    public static final String DEFAULT_SHARE_NUM_STR = "10万+转发";

    /**
     * 问答id列表
     */
    private List<Long> qaIds;

    /**
     * 私信小科普id
     */
    private Long knowledgeId;

    /**
     *content类型
     */
    private String contentType;

    /**
     *
     *自定义标签
     * max length = 255
     */
    private String customizeTags;

    /**
     *
     *内容简介
     * max length = 511
     */
    private String contentIntro;

    /**
     *
     *推荐文章ids
     * max length = 255
     */
    private String recommendContentIds;

}
