package cn.com.duiba.kjy.api.enums.sellerImport;


/**
 * @author xiaotian
 * 爬虫文章类型，外加默认图片
 */
public enum ImportSourceTypeEnum {
    /**
     * 百度文章
     */
    BAIDU(1,"url"),

    /**
     * 快小编
     */
    KXB(2,"url"),

    /**
     * 人民日报
     */
    PEOPLE(3,"url"),

    /**
     * 新浪财经
     */
    SINA_FINANCE(4,"url"),

    /**
     * 抖音视频
     */
    TIKTOK(5,"url"),

    /**
     * 今日头条
     */
    TODAY_LINE(6,"url"),

    /**
     * 人人都是产品经理
     */
    WO_SHI_PM(7,"url"),

    /**
     * 微信公众号
     */
    WX_PLAT(8,"url"),

    /**
     * 全网链接
     */
    NETWORK_LINK(9,"url")
    ;

    ImportSourceTypeEnum(Integer code, String image) {
        this.code = code;
        this.image = image;
    }

    private Integer code;
    private String image;

    public Integer getCode() {
        return code;
    }

    public String getImage() {
        return image;
    }
}
