package cn.com.duiba.kjy.api.params.sellercard;

import lombok.Data;

import java.io.Serializable;

/**
 * 名片评价统计 更新参数
 * @author 吴文哲
 * @date 2020-03-17 17:00
 **/
@Data
public class SellerCardAppraiseStatisticUpdateParam implements Serializable {
    private static final long serialVersionUID = -7860651349068786825L;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 评价上一次的状态
     * @see cn.com.duiba.kjy.api.enums.sellercard.AppraiseStateEnum
     */
    private Integer fromAppraiseState;

    /**
     * 评价本次的状态
     * @see cn.com.duiba.kjy.api.enums.sellercard.AppraiseStateEnum
     */
    private Integer toAppraiseState;

    /**
     * 当前评价的星级
     */
    private Integer star;
}
