package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 销售团队remote
 * @author zhanghuifeng
 * date 2020/3/24-10:44 上午
 */
@AdvancedFeignClient
public interface RemoteSellerTeamService {

    /**
     * 绑定上下级
     * @param parentSid 邀请人销售ID
     * @param sellerId 销售ID
     * @return 结果
     */
    Boolean bound(Long parentSid, Long sellerId);

    /**
     * 根据下级ID查询条数
     * @param sellerId 下级销售ID
     * @return 条数
     */
    int countBySid(Long sellerId);

    /**
     * 获取所有上级代理人id集合
     * @param sellerId 代理人ID
     * @return 上级代理人ID
     */
    List<Long> findParentSids(Long sellerId);

    /**
     * 获取当前代理人上级ID
     * @param sellerId 代理人ID
     * @return 上级ID
     */
    Long findParentId(Long sellerId);
}
