package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 客户营销  代理人客户信息检索参数类
 * @author 吴文哲
 * @date 2019-12-19 11:31
 **/
@Data
public class SellerCustomerSearchParam extends PageQuery implements Serializable {

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 代理人客户信息检索  备注名/微信昵称
     */
    private String content;
    /**
     * 客户来源 1:微信好友 2:二度人脉
     */
    private Integer custOrigin;

    /**
     * 排序类型(0:默认排序(名字首字母),1:访问次数从高到低,2:访问次数从低到高,3:最近访问时间从近到远,4:最近访问时间从远到近)
     */
    private Integer sortType;

    /**
     * 查询成为客户的开始时间
     */
    private Date startDate;
    /**
     *最后访问时间
     */
    private Date lastVisitTime;
    /**
     * 是否为特别关注客户
     */
    private Integer isSpecialCustomer;
    /**
     * 标签列表
     */
    private List<Long> tagIds;
}
