package cn.com.duiba.kjy.api.remoteservice.sellerTag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellerTag.SellerTagDto;

import java.util.List;

/**
 * 销售标签管理
 * @Author chentiecheng
 * @Date 2020/6/6 10:36 上午
 */
@AdvancedFeignClient
public interface RemoteSellerTagService {

    /**
     * 新增标签
     * @param dto
     * @return
     */
    Boolean addTag(SellerTagDto dto);

    /**
     * 更新标签
     * @param dto
     * @return
     */
    Boolean updateTag(SellerTagDto dto);

    /**
     * 根据销售id和标签id删除标签
     * @param sellerId
     * @param tagId
     * @return
     */
    Boolean deleteTag(Long sellerId,Long tagId);

    /**
     * 根据销售id获取所有标签
     * @param sellerId
     * @return
     */
    List<SellerTagDto> getTagListBySellerId(Long sellerId);

}
