package cn.com.duiba.kjy.api.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by dugq on 2019-09-27.
 */
public enum Province4NationalDayEnum {
    guangdong(1, "广东", 10, "粤", 113460),
    shandong(2, "山东", 11, "鲁", 100470),
    henan(3, "河南", 12, "豫", 96050),
    sichuan(4, "四川", 14, "川", 83410),
    jiangshu(5, "江苏", 14, "苏", 80510),
    hebei(6, "河北", 15, "冀", 75560),
    hunan(7, "湖南", 16, "湘", 68990),
    anhui(8, "安徽", 18, "皖", 63240),
    hubie(9, "湖北", 19, "鄂", 59170),
    zhejiang(10, "浙江", 20, "浙", 57370),
    guagnxi(11, "广西", 23, "桂", 49260),
    yunan(12, "云南", 23, "云", 48300),
    jiangxi(13, "江西", 24, "赣", 46480),
    liaoning(14, "辽宁", 26, "辽", 43590),
    fujiang(15, "福建", 29, "闽", 39410),
    shanxi(16, "陕西", 29, "陕", 38640),
    sahnxi(17, "山西", 31, "晋", 37180),
    guizhou(18, "贵州", 32, "贵", 36000),
    chognqing(19, "重庆", 37, "渝", 31020),
    jiling(20, "吉林", 42, "吉", 27040),
    gansu(21, "甘肃", 43, "甘", 26370),
    neimenggu(22, "内蒙古", 45, "蒙", 25340),
    xijiang(23, "新疆", 46, "新", 24870),
    shanghai(24, "上海", 47, "沪", 24240),
    taiwan(25, "台湾", 48, "台", 23500),
    beiji(26, "北京", 53, "京", 21540),
    tianjing(27, "天津", 73, "津", 15600),
    hainan(28, "海南", 121, "琼", 9340),
    xianggang(29, "香港", 152, "港", 7482),
    ningxia(30, "宁夏", 165, "宁", 6880),
    qinghai(31, "青海", 190, "青", 5983),
    xizang(32, "西藏", 330, "藏", 3440),
    aomen(33, "澳门", 1688, "澳", 672),
    heilongjiang(34, "黑龙江", 30, "黑", 37730),

    ;
    private Integer code;
    private String name;
    private Integer hotScoreUnit;
    private String shortName;
    private Integer people;

    Province4NationalDayEnum(Integer code, String name, Integer hotScoreUnit,String shortName,Integer people) {
        this.code = code;
        this.name = name;
        this.hotScoreUnit = hotScoreUnit;
        this.shortName = shortName;
        this.people = people;
    }

    public Integer getPeople() {
        return people;
    }

    public String getShortName() {
        return shortName;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public Integer getHotScoreUnit() {
        return hotScoreUnit;
    }

    public static List<Integer> getCodeList(){
       return Arrays.stream(Province4NationalDayEnum.values()).map(Province4NationalDayEnum::getCode).collect(Collectors.toList());
    }

    public static Province4NationalDayEnum getByCode(Integer code) {
        for (Province4NationalDayEnum enumVal : Province4NationalDayEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }
}
