package cn.com.duiba.kjy.api.dto.resourceLocator;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 资源位信息表
 * @author kjj mybatis generator 
 * 2020-04-24
 */
@Data
public class ResourceLocatorDto implements Serializable {
    private static final long serialVersionUID = 15876933112942180L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *tab栏分类,1:首页icon,2:首页信息流
     * not null default = null
     */
    private Integer tabType;

    /**
     *
     *资源位分类,101:发圈素材,102:获客文章...
     * not null default = null
     */
    private Integer resourceType;

    /**
     *
     *资源位图标
     * max length = 512
     */
    private String resourceImg;

    /**
     *
     *资源位名称
     * max length = 50
     * not null default = null
     */
    private String resourceName;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}