package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.OfficialAccountDto;
import cn.com.duiba.kjy.api.dto.UserDto;
import cn.com.duiba.kjy.api.dto.UserExtDto;
import cn.com.duiba.kjy.api.dto.user.UserIdUnionIdDto;
import cn.com.duiba.kjy.api.dto.user.UsersNicknameAvatarDto;
import cn.com.duiba.kjy.api.params.UserSearchParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 保存用户
     * @param dto
     * @return
     */
    Long save(UserDto dto);

    /**
     * 保存用户扩展信息
     * @param dto
     * @return
     */
    Boolean saveUserExt(UserDto dto);

    /**
     * 保存用户手机号
     * @param dto
     * @return
     */
    Boolean updatePhoneNumber(UserDto dto);

    /**
     * 更新用户是否关注公众号
     * @param dto
     * @return
     */
    Boolean updateUserSubscribe(UserDto dto);

    /**
     * 根据id查询基本信息
     * @param userId
     * @return
     */
    UserDto selectById(Long userId);

    /**
     * 通过id列表批量查询用户
     * @param ids
     * @return
     */
    List<UserDto> findByIds(List<Long> ids);

    /**
     * 通过id列表批量查询用户
     * @param ids
     * @return
     */
    Map<Long, UserDto> findMapByIds(List<Long> ids);


    UserDto selectByUnionId(String unionId);

    /**
     * 根据openId查询
     * @param openId
     * @return
     */
    UserDto findByOpenId(String openId);

    /**
     * 根据sellerId查询
     * @param sellerId
     * @return
     */
    /**
     * 扩展信息单独查询一次
     * @param sellerId
     * @return
     */
    UserDto findBySellerId(Long sellerId);


    /**
     * 查询用户扩展信息
     * @param openid
     * @return
     */
    UserDto findExtByOpenid(String openid);

    /**
     * 查询用户扩展信息
     * @param extType
     * @param ids
     * @return
     */
    /**
     * 请使用ext中的方法
     * @param extType
     * @param ids
     * @return
     */
    @Deprecated
    Map<Long, UserExtDto> findExtMapByUserIds(String extType, List<Long> ids);

    /**
     * 查询用户扩展信息
     * @param userId
     * @param extType
     * @return
     */
    /**
     *  extType + userId 不在是唯一索引 在多公众号功能上线后，此方法会报错
     *  建议使用selectById 单纯只查用户基本信息，扩展信息使用remoteUserExtService
     * @param userId
     * @param extType
     * @return
     */
    @Deprecated
    UserDto findExtByUserAndType(Long userId, String extType);

    int modifyLastPushEventTime(String openId, Date date);

    List<UserDto> findByParam(UserSearchParam userParam);

    Boolean updateAvatar(Long userId, String avatar);

    OfficialAccountDto findOaByOpenId(String openId);

    Map<Long/*oaId**/,List<String>/*openIds**/> findOaByOpenIds(List<String> openIds);

    UserDto selectByNickname(String nickname);

    /**
     * 根据用户ID查询
     * @param userId 用户ID
     * @param extType 类型
     *                计划移除
     * @return
     */
    @Deprecated
    UserDto findById(Long userId, String extType);

    /**
     * 根据用户主键更新
     * @param userDto
     * @return
     */
    Integer updateById(UserDto userDto);

    /**
     * 根据昵称模糊查找所有用户的id
     * @param nickName
     * @return
     */
    List<Long> findIdsByNickName(String nickName);

    /**
     * 根据主键查询昵称和头像
     * @param userIds 主键集合
     * @return 昵称和头像集合
     */
    List<UsersNicknameAvatarDto> findNicknameAndAvatarsByIds(List<Long> userIds);

    /**
     * 根据主键物理删除
     * 代理人演示数据专用
     * @return
     */
    Integer deleteByIds(List<Long> ids);



    /**
     * 批量新增
     * @param usersEntityList
     * @return
     */
    Integer batchInsert(List<UserDto> usersEntityList);

    /**
     * 批量跟新头像。新增的时候批量延迟跟新头像
     * 注意： 根据unionId 跟新
     * @param usersEntityList
     * @return
     */
    Integer batchUpdateAvatar(List<UserDto> usersEntityList);

    /**
     * 批量跟新用户头像和昵称  适用于新用户异步批量上传图片到oss 后跟新数据库头像和昵称
     * 注意： 根据unionId 跟新
     * @param usersEntityList
     * @return
     */
    Integer batchUpdateNickNameAvatar(List<UserDto> usersEntityList);

    /**
     * 根据unionIDs查询userID
     * @param unionIds
     * @return
     */
    List<UserIdUnionIdDto> selectIdByUnionIds(List<String> unionIds);

    /**
     * 禁用账号
     * @param userId 用户id
     * @return 处理结果
     * @throws KjyCenterException
     */
    boolean disableByUserId(Long userId) throws KjyCenterException;

}
