package cn.com.duiba.kjy.api.remoteservice.dailyPostersConfig;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.dailypostersconfig.DailyPostersConfigDto;
import cn.com.duiba.kjy.api.params.dailyPosters.DailyPostersConfigListParams;

import java.util.Date;
import java.util.List;

/**
 * 每日唤醒推送海报配置管理
 * @author chentiecheng
 * @Date 2020-06-16
 */
@AdvancedFeignClient
public interface RemoteDailyPostersConfigService {

    /**
     * 分页获取日签配置信息（管理后端使用）
     *
     * @param params
     * @return
     */
    List<DailyPostersConfigDto> selectPage(DailyPostersConfigListParams params);

    /**
     * 查询总数
     * @param params
     * @return
     */
    Long selectCount(DailyPostersConfigListParams params);
    /**
     * 根据时间和类型获取配置信息
     * @param date 日期
     * @param type 海报配置类型
     * @return
     */
    DailyPostersConfigDto selectByTypeAndTime(Integer type,Date date);

    /**
     * 根据是否存在ID判断更新或者插入操作（管理后端使用）
     *
     * @param dailyPostersConfigDto
     * @return
     */
    boolean insertOrUpdate(DailyPostersConfigDto dailyPostersConfigDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);


    /**
     * 根据ID获取配置信息
     *
     * @param id
     * @return
     */
    DailyPostersConfigDto findById(Long id);

    /**
     * 试推
     * @param sellerId
     * @param id
     * @return
     */
    Boolean tryPush(Long sellerId,Long id);
}
