package cn.com.duiba.kjy.api.remoteservice.collect;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.collect.UserContentCollectDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;
import java.util.Map;

/**
 * @author linjianhui
 * @description 用户文章收藏
 * @date 2019-11-06 15:59
 */
@AdvancedFeignClient
public interface RemoteUserContentCollectService {

    /**
     * 保存收藏记录
     * @param dto
     * @return 返回插入的id
     */
    Long saveContentCollect(UserContentCollectDto dto);

    /**
     * 通过用户id查询收藏条数
     * @param userId
     * @return
     */
    Integer selectCollectNum(Long userId);

    /**
     * 查询当前用户收藏对应代理人文章信息
     * @param userId
     * @param scid
     * @return
     */
    UserContentCollectDto selectByUserIdAndScId(Long userId,Long scid);

    /**
     * 查询访客是否关注代理人文章
     * @param userIds
     * @return
     */
    Map<String,Boolean> selectCollectInfo(List<Long> userIds);

    /**
     * 用户收藏文章列表
     * 分页查询
     * @param userId
     * @param pageQuery
     * @return
     */
    Page<UserContentCollectDto> findCollectPage(Long userId, PageQuery pageQuery);

    /**
     * 根据访问ids查询收藏列表
     * @param visitTableIds
     * @return
     */
    List<UserContentCollectDto> listByVisitTableIds(List<Long> visitTableIds);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    UserContentCollectDto findById(Long id);

    /**
     * 根据主键删除
     * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);
}
