package cn.com.duiba.kjy.api.params.accurate;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 精准素材查询参数
 * @author 吴文哲
 * @date 2020-05-12 16:21
 **/
@Data
public class AccurateContentQueryParam extends PageQuery {
    private static final long serialVersionUID = -3958412560304283550L;

    /**
     * 精准素材发布状态 1:草稿 2:正常
     * @see cn.com.duiba.kjy.api.constant.ContentStatusEnum
     */
    private Integer status;

    /**
     * 素材id
     */
    private Long contentId;

    /**
     * 素材id列表
     */
    private List<Long> contentIds;

    /**
     * 精准素材类型
     * @see cn.com.duiba.kjy.api.enums.accurate.AccurateContentTypeEnum
     */
    private Integer accurateContentType;

    /**
     * 一级标签id
     */
    private Long firstTagId;

    /**
     * 二级标签id
     */
    private Long secondTagId;

    /**
     * 三级标签id
     */
    private Long thirdTagId;

    /**
     * 筛选发布时间（开始）
     */
    private Date startReleaseTime;

    /**
     * 筛选发布时间（结束）
     */
    private Date endReleaseTime;
}
