package cn.com.duiba.kjy.api.dto.weeklystats;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 代理人周报营销工具统计
 * @author kjj mybatis generator 
 * 2020-07-13
 */
@Data
public class WeeklyMarketingStatsDto implements Serializable {
    private static final long serialVersionUID = 1594607724273762L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *销售id，对应tb_sellers.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *周开始时间
     * not null default = null
     */
    private Date startDate;

    /**
     *
     *周结束时间
     * not null default = null
     */
    private Date endDate;

    /**
     *
     *统计类型
     * @see cn.com.duiba.kjy.api.enums.weekly.MarketingStatsTypeEnum
     */
    private Integer statsType;

    /**
     *
     *来访数
     * not null default = 0
     */
    private Integer visitCount;

    /**
     *
     *使用次数
     * not null default = 0
     */
    private Integer useCount;

    /**
     *
     *参与人数
     * not null default = 0
     */
    private Integer participantCount;

    /**
     *
     *领取礼物人数
     * not null default = 0
     */
    private Integer giftCount;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}