package cn.com.duiba.kjy.api.dto.home;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangbinbin
 * @create 2020-03-25 14:05
 * @descript 首页频道页公众号dto
 */
@Data
public class SubscriptionDto implements Serializable {

    private static final long serialVersionUID = 6887978731011462000L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 对应tb_grab_web.id
     */
    private Long grabWebId;

    /**
     * 公众号名称
     */
    private String subName;

    /**
     * 公众号简介
     */
    private String subIntroduction;

    /**
     * 公众号头像
     */
    private String subAvatar;

    /**
     * 公众号标签，对应tb_kjy_tag.id
     */
    private Long subTagId;

    /**
     * 是否新闻类,1:不是，2:是
     */
    private Integer isNews;

    /**
     * 是否启用 1=启用 0=禁用
     */
    private Integer isOpen;

    /**
     * 公众号上新时间
     */
    private Date upToDateTime;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

}
