package cn.com.duiba.kjy.api.remoteservice.wakeUpPush;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.wakeuppushconfig.WakeUpPushConfigDto;
import cn.com.duiba.kjy.api.params.wakeup.WakeUpPushListParam;

import java.util.List;

/**
 * 唤醒推送配置管理
 * @Author chentiecheng
 * @Date 2020/6/30 11:56 上午
 */
@AdvancedFeignClient
public interface RemoteWakeUpPushConfigService {
    /**
     * 获取列表
     * @param param
     * @return
     */
    List<WakeUpPushConfigDto> getPageList(WakeUpPushListParam param) ;

    /**
     * 根据参数获取总数
     * @param param
     * @return
     */
    Long countByParam(WakeUpPushListParam param);
    /**
     * 根据id删除
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 新增编辑
     * @param dto
     * @return
     */
    Boolean addOrUpdate(WakeUpPushConfigDto dto) ;

    /**
     * 根据id获取回复内容
     * @param id
     * @return
     */
    WakeUpPushConfigDto selectOneById(Long id);
    /**
     * 更新状态
     * @param id
     * @param state
     * @return
     */
    Boolean updateState(Long id,Integer state);
}
