package cn.com.duiba.kjy.api.enums.weekly;

import java.util.Objects;

/**
 * 周报内容数据统计类型
 * @Author chentiecheng
 * @Date 2020/7/13 8:20 下午
 */
public enum ContentStatsTypeEnum {
    CONTENT(1,"热门素材数据"),
    QUESTION(2,"问答数据"),
    ASSESSMENT(3,"测评数据")
    ;
    private Integer code;
    private String desc;

    ContentStatsTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }


    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static ContentStatsTypeEnum getByCode(Integer code){
        if(Objects.isNull(code)){
            return null;
        }
        for(ContentStatsTypeEnum enums : ContentStatsTypeEnum.values()){
            if(Objects.equals(enums.getCode(),code)){
                return enums;
            }
        }
        return null;
    }
}
