package cn.com.duiba.kjy.api.remoteservice.enhanced;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.enhanced.EnhancedColumnQuestionDto;
import cn.com.duiba.kjy.api.enums.enhanced.EnhancedColumnQuestionOpenEnum;
import cn.com.duiba.kjy.api.params.EnhancedColumnQuestionParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-03-16 09:54
 * @descript 个人专栏FAQ远程方法
 */
@AdvancedFeignClient
public interface RemoteEnhancedColumnQuestionService {

    /**
     * 更改问题id的打开状态
     * @param questionId
     * @param isOpen
     * @see EnhancedColumnQuestionOpenEnum
     * @return
     */
    boolean editQuestionOpenStatus(Long questionId, Integer isOpen);

    /**
     * 上下移动
     * @param id
     * @param moveType
     * @see cn.com.duiba.kjy.api.enums.MoveTypeEnum
     * @return
     */
    boolean move(Long id, Integer moveType);

    /**
     * 查询问题列表
     * @param param
     * @return
     */
    List<EnhancedColumnQuestionDto> listEnhancedColumnQuestionDtos(EnhancedColumnQuestionParam param);

    /**
     * 查询问题总数
     * @param param
     * @return
     */
    int countEnhancedColumnQuestionNum(EnhancedColumnQuestionParam param);
}
