/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.whosawme;

import cn.com.duiba.kjy.api.enums.clue.VisitClueTypeEnum;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public enum UserClueTypeEnum {
    SALE_CHANCE(1, "\u9500\u552e\u673a\u4f1a", VisitClueTypeEnum.getSaleChanceCode()),
    RECRUIT_CHANCE(2, "\u589e\u5458\u673a\u4f1a", VisitClueTypeEnum.getRecruitChanceCode()),
    COMPLETE_INFO(3, "\u5b8c\u5584\u8d44\u6599", null),
    CUSTOMER_FORWARD(4, "\u8f6c\u53d1", null);

    private Integer code;
    private String desc;
    private List<Integer> subClue;

    private UserClueTypeEnum(Integer code, String desc, List<Integer> subClue) {
        this.code = code;
        this.desc = desc;
        this.subClue = subClue;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public List<Integer> getSubClue() {
        return this.subClue;
    }

    public static List<Integer> getSubClueByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (UserClueTypeEnum clueTypeEnum : UserClueTypeEnum.values()) {
            if (!Objects.equals(clueTypeEnum.code, code)) continue;
            return clueTypeEnum.getSubClue();
        }
        return null;
    }

    public static UserClueTypeEnum getBySubClue(Integer clueType) {
        if (Objects.isNull(clueType)) {
            return null;
        }
        for (UserClueTypeEnum clueTypeEnum : UserClueTypeEnum.values()) {
            if (CollectionUtils.isEmpty(clueTypeEnum.getSubClue()) || !clueTypeEnum.getSubClue().contains(clueType)) continue;
            return clueTypeEnum;
        }
        return null;
    }
}

