package cn.com.duiba.kjy.api.dto.clue;

import cn.com.duiba.kjy.api.dto.accurate.SellerAccurateMaterialDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-01-14 20:40
 * @descript 代理人线索详情dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerAccurateMaterialExtDto extends SellerAccurateMaterialDto implements Serializable {

    private static final long serialVersionUID = 7698094305906282730L;

    /**
     * (FAQ事件)常见问题内容
     */
    private String FAQQuestionContent;

    /**
     * (FAQ事件)常见问题内容（额外关联问答）
     */
    private String FAQExtraQuestionContent;

    /**
     * (访问产品内容事件)产品名称
     */
    private String productName;

    /**
     * (月访问精准爆款素材事件使用)访问素材总数
     */
    private Integer monthVisitAECount;

    /**
     * (月访问精准爆款素材事件使用)访问记录id列表
     */
    private List<Long> visitTableIds;

    /**
     * (种草素材内的投票)投票ids
     */
    private List<Long> voteIds;

    /**
     * 资源id,对应tb_explosion_content_resource.id
     */
    private Long resourceId;

    /**
     *
     *来源位置 0:无 1:文章内  2:个人专栏
     * not null default = 0
     */
    private Integer locationSource;

    /**
     * 资料包标题
     */
    private String materialTitle;

}
