package cn.com.duiba.kjy.api.enums;

/**
 * @author zhanghuifeng
 * date 2019-04-19-15:40
 */
public enum BatchCodeRuleEnum {

    NUMBER("number", "纯数字"),
    LETTER("letter","纯字母"),
    NUM_LETTER("num_letter", "字母+数字"),
    ;
    private String code;

    private String desc;

    BatchCodeRuleEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static BatchCodeRuleEnum getByCode(String code) {
        for (BatchCodeRuleEnum enumVal : BatchCodeRuleEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(String code) {
        for (BatchCodeRuleEnum enumVal : BatchCodeRuleEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
