package cn.com.duiba.kjy.api.remoteservice.customize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.customize.CustomizeFieldDto;
import cn.com.duiba.kjy.api.params.customize.CustomizeFieldQryParams;

import java.util.List;
import java.util.Map;

/**
 * @author wangbinbin
 * @create 2019/6/28 10:51
 * @descript 自定义字段RPC调用服务
 */
@AdvancedFeignClient
public interface RemoteCustomizeFieldService {

    /**
     * 分页查询 获取列表
     * @param params
     * @return
     */
    List<CustomizeFieldDto> findPageList(CustomizeFieldQryParams params);

    /**
     * 分页查询 获取总数
     * @param params
     * @return
     */
    int findPageCount(CustomizeFieldQryParams params);

    /**
     * 新增
     * @param entity
     * @return
     */
    int add(CustomizeFieldDto entity);

    /**
     * 更新
     * @param entity
     * @return
     */
    int update(CustomizeFieldDto entity);

    /**
     * 删除
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 根据代码列表获取map数据
     * @param codes
     * @return
     */
    Map<String, CustomizeFieldDto> getMapByCodes(List<String> codes);

    /**
     * 获取所有自定义字段
     * @return
     */
    List<CustomizeFieldDto> getAllCustmoizeField();
}
