package cn.com.duiba.kjy.api.dto.orderRefund;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @author kjj mybatis generator 
 * 2020-04-26
 */
@Data
public class OrderRefundDto implements Serializable {
    private static final long serialVersionUID = 15878729631059237L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *付款订单ID
     * not null default = null
     */
    private Long payOrderId;

    /**
     *
     *微信的支付ID
     * max length = 45
     */
    private String payWxId;

    /**
     *
     *销售ID
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *退款业务订单号
     * max length = 45
     */
    private String bizRefundNo;

    /**
     *
     *退款金额
     * not null default = null
     */
    private Integer refundAmount;

    /**
     *
     *实际退款时间
     */
    private Date refundTime;

    /**
     *
     *审核状态 ：0:待退款 1:退款中 2:退款成功 3:退款失败
     * not null default = 0
     */
    private Integer refundStatus;

    /**
     *
     *审核状态：0:待审核 1:审核通过 2:审核拒绝
     * not null default = 0
     */
    private Integer checkStatus;

    /**
     *
     *审批备注
     * max length = 200
     */
    private String checkRemark;

    /**
     *
     *微信退款返回的订单ID
     * max length = 200
     */
    private String outOrderId;

    /**
     *
     *钉钉审批流程ID
     * max length = 100
     */
    private String dingProcessId;

    /**
     *
     *提交人
     * max length = 45
     * not null default = null
     */
    private String submitter;

    /**
     *
     *审核人
     * max length = 45
     */
    private String checker;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     *
     *提交人ID
     */
    private Long submitterId;

    /**
     *
     *审批人ID
     */
    private Long checkerId;

    /**
     *
     *提交审批备注
     * max length = 200
     */
    private String submitRemark;

    /**
     *
     * 退款申请来源：1:内部人员管理后台操作发起 2:完成60天打卡任务，系统发起
     * not null default = 1
     */
    private Integer refundSource;
}