package cn.com.duiba.kjy.api.enums.preInsatll;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author xiaotian
 * @date 2020/1/7 3:43 PM
 */
public enum PreInstallBatchStatusEnum {

    USE(1, "直播试用账号"),
    NON_USE(0,"禁用"),
    DELETE(-1,"删除")
    ;

    private Integer code;
    private String desc;

    PreInstallBatchStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, PreInstallBatchStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PreInstallBatchStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static PreInstallBatchStatusEnum getByCode(Integer code) {
        PreInstallBatchStatusEnum preInstallBatchStatusEnum = ENUM_MAP.get(code);
        if(Objects.isNull(preInstallBatchStatusEnum)){
            return NON_USE;
        }
        return preInstallBatchStatusEnum;
    }

    public static Boolean change2NoUse(Integer code) {
        PreInstallBatchStatusEnum preInstallBatchStatusEnum = getByCode(code);
        if(preInstallBatchStatusEnum.equals(PreInstallBatchStatusEnum.NON_USE) || preInstallBatchStatusEnum.equals(PreInstallBatchStatusEnum.DELETE)){
            return true;
        }
        return false;
    }
}
