package cn.com.duiba.kjy.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.content.ContentLikeDto;
import cn.com.duiba.kjy.api.params.content.ContentLikeParam;

import java.util.List;

/**
 * 素材点赞rpc服务
 * @author 吴文哲
 * @date 2020-08-17 20:05
 **/
@AdvancedFeignClient
public interface RemoteContentLikeService {

    /**
     * 获取访客针对代理人素材点赞
     * @param param
     * @return
     */
    ContentLikeDto getContentLike(ContentLikeParam param);

    /**
     * 获取访客针对代理人素材点赞列表
     * @param param
     * @return
     */
    List<ContentLikeDto> getContentListList(ContentLikeParam param);

    /**
     * 新增素材点赞记录
     * @param contentLikeDto
     * @return
     */
    Boolean addContentLike(ContentLikeDto contentLikeDto);

    /**
     * 根据主键自增点赞次数
     * @param id
     * @return
     */
    Boolean increaseContentLikeTimes(Long id);


}
