/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.pay;

import cn.com.duiba.kjy.api.enums.pay.ChargeStatusEnum;
import java.util.HashMap;
import java.util.Map;

public enum RefundStatusEnum {
    INIT(1, "\u521d\u59cb\u5316\u72b6\u6001"),
    ORDER_FAILED(2, "\u7b2c\u4e09\u65b9\u9000\u6b3e\u7533\u8bf7\u5931\u8d25"),
    ORDER_SUCCEEDED(3, "\u7b2c\u4e09\u65b9\u9000\u6b3e\u7533\u8bf7\u6210\u529f"),
    SUCCEEDED(4, "\u9000\u6b3e\u6210\u529f"),
    FAILED(5, "\u9000\u6b3e\u5931\u8d25"),
    KJJ_DUIBA_ERROR(21, "\u8c03\u7528\u5151\u5427\u5931\u8d25");

    private Integer code;
    private String desc;
    private static final Map<Integer, RefundStatusEnum> ENUM_MAP;

    private RefundStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static RefundStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static ChargeStatusEnum getChargeStatusEnum(Integer code) {
        RefundStatusEnum statusEnum = RefundStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return null;
        }
        if (RefundStatusEnum.isRefundSuccess(code)) {
            return ChargeStatusEnum.REFUND_SUCCESS;
        }
        if (RefundStatusEnum.isRefundFail(code)) {
            return ChargeStatusEnum.REFUND_FAIL;
        }
        return null;
    }

    public static boolean isRefundSuccess(Integer code) {
        RefundStatusEnum statusEnum = RefundStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == SUCCEEDED;
    }

    public static boolean isRefundFail(Integer code) {
        RefundStatusEnum statusEnum = RefundStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == FAILED || statusEnum == KJJ_DUIBA_ERROR || statusEnum == ORDER_FAILED;
    }

    public static boolean isFinal(Integer code) {
        RefundStatusEnum statusEnum = RefundStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return RefundStatusEnum.isRefundFail(code) || RefundStatusEnum.isRefundSuccess(code);
    }

    static {
        ENUM_MAP = new HashMap<Integer, RefundStatusEnum>();
        for (RefundStatusEnum tmp : RefundStatusEnum.values()) {
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }
}

