package cn.com.duiba.kjy.api.params.company;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author linjianhui
 * @description  公司es查询参数
 * @date 2020-07-14 14:42
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CompanyEsParam extends PageQuery {

    /**
     * tb_company表主键
     */
    private Long id;

    /**
     * id列表，tb_company表主键
     */
    private List<Long> ids;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司等级
     */
    private Integer companyLevel;

    /**
     * 行业Id
     */
    private Long tradeId;

    /**
     * 是否倒序
     */
    private Boolean isDesc = Boolean.TRUE;

    /**
     * 根据首字母排序
     */
    private Boolean indexChar;

}
