package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.companyTradeAppraiseTemplate.CompanyTradeAppraiseTemplateDto;
import cn.com.duiba.kjy.api.dto.companyTradeCaseTemplate.CompanyTradeCaseTemplateDto;
import cn.com.duiba.kjy.api.params.company.CompanyTradeCaseListParam;

import java.util.List;

/**
 * 公司企业案例模版
 * @Author chentiecheng
 * @Date 2020/5/8 3:35 下午
 */
@AdvancedFeignClient
public interface RemoteCompanyTradeCaseTemplateService {

    /**
     * 统计总数
     * @param param
     * @return
     */
    Long selectCount(CompanyTradeCaseListParam param);

    /**
     * 根据条件分页查询个人介绍模板
     * @param param
     * @return
     */
    List<CompanyTradeCaseTemplateDto> selectListByParam(CompanyTradeCaseListParam param);

    /**
     * 新增个人介绍模板
     * @param dto
     * @return
     */
    Boolean insert(CompanyTradeCaseTemplateDto dto);

    /**
     * 更新个人介绍模板
     * @param dto
     * @return
     */
    Boolean update(CompanyTradeCaseTemplateDto dto);

    /**
     * 删除个人介绍模板
     * @param id
     * @return
     */
    Boolean delete(Long id);
    /**
     * 根据id查询案例模版
     * @param id
     * @return
     */
    CompanyTradeCaseTemplateDto selectById(Long id);
}
