package cn.com.duiba.kjy.api.remoteservice.userAvatarRetry;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sourcereload.SourceReloadDto;

import java.util.List;
import java.util.Map;

/**
 * 用户微信头像下载重试
 * @Author chentiecheng
 * @Date 2020/06/22 10:09 下午
 */
@AdvancedFeignClient
public interface RemoteUserAvatarRetryService {
    /**
     * 批量更新，只更新次数
     * @param userIds
     * @return
     */
    Integer batchUpdateByUserIds(List<Long> userIds);

    /**
     * 根据用户id列表删除记录
     * @param userIds
     * @return
     */
    Integer batchDeleteByUserIds(List<Long> userIds);
}
