package cn.com.duiba.kjy.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/10/23 3:10 PM
 */
public enum PrizeTypeEnum {

    THANKS(1, "谢谢参与"),
    AGAIN(2, "再来一次"),
    SELLER_CUSTOM(3, "销售员定制"),
    COUPON_LINK(4, "链接优惠券"),
    OBJECT(5, "实物"),
    SELLER_RATE(6, "销售员概率出奖"),
    ;

    private Integer type;

    private String desc;

    PrizeTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, PrizeTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PrizeTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static PrizeTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 是否是中奖类型
     * @param type 类型
     * @return true-是中奖类型，false-不是中奖类型
     */
    public static boolean isWinning(Integer type) {
        if (type == null) {
            return false;
        }
        return !type.equals(AGAIN.getType()) && !type.equals(THANKS.getType());
    }

    public static boolean isSellerPrize(Integer type) {
        PrizeTypeEnum typeEnum = getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == SELLER_CUSTOM || typeEnum == SELLER_RATE;
    }

    /**
     * 是否不限制中奖次数
     * @return true-不限制， false-限制
     */
    public boolean notWinningTimesLimit() {
        return this == THANKS || this == AGAIN;
    }

    /**
     * 是否不限制库存
     * @return true-不限制，false-限制
     */
    public boolean notStockLimit() {
        return this == THANKS || this == AGAIN;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
