package cn.com.duiba.kjy.api.remoteservice.sellerfollowrecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellerfollowrecord.SellerFollowRecordDto;
import cn.com.duiba.kjy.api.params.sellerfollowrecord.SellerFollowRecordParam;

import java.util.List;

/**
 * 客户跟进记录
 * @Author chentiecheng
 * @Date 2020/4/24 10:25 上午
 */
@AdvancedFeignClient
public interface RemoteSellerFollowRecordService {
    /**
     * 客户跟进列表查询
     * @param sellerFollowRecordParam
     * @return
     */
    List<SellerFollowRecordDto> getListForParam(SellerFollowRecordParam sellerFollowRecordParam);

    /**
     * 根据id列表查询
     * @param ids
     * @return
     */
    List<SellerFollowRecordDto> findByIds(List<Long> ids);

    /**
     * 查询数据总数
     * @param sellerFollowRecordDto
     * @return
     */
    Long selectCount(SellerFollowRecordDto sellerFollowRecordDto);

    /**
     * 删除跟进记录
     * @param sellerId  销售id
     * @param userId 用户id
     * @param id 要删除的记录
     * @return
     */
    Boolean delFollowRecord(Long sellerId,Long userId,Long id);

    /**
     * 新增客户跟进记录
     * @param dto
     * @return
     */
    Boolean addFollowRecord(SellerFollowRecordDto dto);
}
