package cn.com.duiba.kjy.api.dto.greeting;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 代理人贺卡配置统计表
 * @author：刘超
 * @Date 2019/12/18 11:38
 * @Version 1.0
 */
@Data
public class SellerGreetingCardStatisticDto implements Serializable {

    private static final long serialVersionUID = -6200961465072634654L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动配置ID，对应tb_seller_greeting_card_conf.id
     */
    private Long confId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private String visitorIds;

    /**
     * 收下贺卡人数
     */
    private Integer receiveNum;

    /**
     * 领取红包的人数
     */
    private Integer redPacketNum;

    /**
     * 领取礼物人数
     */
    private Integer giftReceiveNum;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private List<Long> visitorIdList;

    public List<Long> getVisitorIdList() {
        if (visitorIds == null || visitorIds.length() == 0) {
            return new ArrayList<>();
        }
        String[] split = visitorIds.split(",");
        try {
            visitorIdList = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
        } catch (Exception ignored) {
        }
        if (visitorIdList == null) {
            return new ArrayList<>();
        }
        return visitorIdList;
    }

}
